package.path = package.path ..';./Scripts/DemoScenes/?.lua;'
local sceneEnvironment = require("demosceneEnvironment")

scene = {} -- сюда кладем все созданные объекты

function loadScene(scenePtr)
	sceneAPI = sceneEnvironment.getInterface(scenePtr)
	sceneAPI:setUpdateFunc('sceneVRUpdate')
	sceneAPI:setEnvironmentMap("Bazar/Graphics/VRMainScene.dds",0.9);
	sceneAPI:setSun(math.rad(150), math.rad(50)) -- положение солнца

	scene.m			= sceneAPI:addModel("ka-27", -4.0, 7.25, -2.0); -- вперёд, вверх, вправо по оси самолёта
	scene.m.transform:setOrient(0, -5, 0)
	scene.m:setArgument(0, 1);
	scene.m:setArgument(3, 1);
	scene.m:setArgument(5, 1);
	scene.m:setArgument(4, 0.25);
	scene.m:setArgument(6, 0.25);
	scene.m:setArgument(40, 15);
	scene.m:setArgument(115, 1);
	scene.m:setArgument(116, 1);
	scene.m:setArgument(117, 1);
	scene.m:setArgument(190, 1);
	scene.m:setArgument(193, 1);
	
	scene.m			= sceneAPI:addModel("ural-apa", -5.25, 0, 12.0); -- вперёд, вверх, вправо по оси самолёта
	scene.m:setArgument(0, 1);
	scene.m:setArgument(3, 1);
	scene.m:setArgument(5, 1);
	scene.m:setArgument(4, 0.25);
	scene.m:setArgument(6, 0.25);
	scene.m:setArgument(115, 1);
	scene.m:setArgument(116, 1);
	scene.m:setArgument(117, 1);
	
	scene.m			= sceneAPI:addModel("atz5", 5.0, 0, 12.0); -- вперёд, вверх, вправо по оси самолёта
	scene.m:setArgument(0, 1);
	scene.m:setArgument(3, 1);
	scene.m:setArgument(5, 1);
	scene.m:setArgument(4, 0.25);
	scene.m:setArgument(6, 0.25);
	scene.m:setArgument(115, 1);
	scene.m:setArgument(116, 1);
	scene.m:setArgument(117, 1);
	
	scene.m			= sceneAPI:addModel("H-Windsock_RW", 16,-0.2,-17); -- вперёд, вверх, вправо по оси самолёта
	scene.m.transform:setOrient(0, 181, 0)
	scene.m:setArgument(0, 1);
	scene.m:setArgument(3, 1);
	scene.m:setArgument(5, 1);
	scene.m:setArgument(4, 0.25);
	scene.m:setArgument(6, 0.25);
	scene.m:setArgument(115, 1);
	scene.m:setArgument(116, 1);
	scene.m:setArgument(117, 1);

	local cam_level = 1.15

	scene.cam		= sceneAPI:addCamera(3, cam_level , 3)
	scene.cam:setFarClip(1000.0)
	scene.cam:setFov(90)
	scene.cam.transform:lookAtPoint(-10.0, cam_level, 0);


	scene.flr		= sceneAPI:addModel("farp", 0,-1.21,-2);
	scene.flr:drawToEnvironment(true);
	scene.flr.transform:scale(1,1,1);

	scene.L1			= sceneAPI:addLightOmni(0, 25, 0,	1,0.8,0.5);
	scene.L1:setRadius(200);
	scene.L1:setAmount(1);

	scene.cam:setActive()

	preloadList = 
	{
		{"atz5", 		  {}, {}},
		{"H-Windsock_RW", {}, {}},
		{"farp", {}, {}},
		{"ka-27", 	  {}, {}},
		{"ural-apa", 	  {}, {}}
	}
	sceneAPI:waitForModels(preloadList)	
end

--[0;1]
local function pingpong(length, t)
	local tt = (t%length)*2/length
	if tt>1 then tt = 2-tt end
	return tt
end


function sceneVRUpdate(t, dt)

end



